<?php defined('BASEPATH') OR exit('No direct script access allowed');
$this->load->view('dashboard/common/head_view');
$this->load->view('dashboard/common/header_view');
//Show relevant sidebar
if ($_SESSION['user_type'] == 1)
    $this->load->view('dashboard/common/sidebar_view');
elseif ($_SESSION['user_type'] == 2)
    $this->load->view('dashboard/common/sidebar_user_view');
?>

<section class="content">
    <div class="container-fluid">
        <div class="row clearfix">
            <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                <div class="card">

                    <div class="body">

                        <?php
                        $attributes = array('class' => 'form-horizontal', 'method' => 'post');
                        echo form_open(base_url()."dashboard/page/edit_page/", $attributes);
                        ?>
                        <div class="form-line">
                            <textarea class="form-control" name="page_content" id="page_content" required><?php echo $pageContent->page_content; ?></textarea>
                        </div>

                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <!-- Alert after process start -->
                <?php
                $msg = $this->session->flashdata('msg');
                $msgType = $this->session->flashdata('msgType');
                if (isset($msg))
                {
                    ?>
                    <div class="alert alert-<?php echo $msgType; ?> alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                        <?php echo $msg; ?>
                    </div>
                    <?php
                }
                ?>
                <!-- ./Alert after process end -->
                <div class="card">
                    <div class="header">
                        <h2>
                            <?php echo $this->lang->line("Edit Page"); ?>
                        </h2>
                        <ul class="header-dropdown m-r--5">
                            <li class="dropdown">
                                <a href="javascript:void(0);" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
                                    <i class="material-icons">more_vert</i>
                                </a>
                                <ul class="dropdown-menu pull-right">
                                    <li><a href="<?php echo base_url()."dashboard/Page/pages"; ?>"><?php echo $this->lang->line("Pages List"); ?></a></li>
                                </ul>
                            </li>
                        </ul>
                    </div>

                    <div class="body">
                        <div class="form-group">
                            <div class="form-line">
                                <input type="text" name="page_title" class="form-control" placeholder="<?php echo $this->lang->line("Page Title"); ?>" value="<?php echo $pageContent->page_title; ?>" required>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="form-line">
                                <?php
                                $page_type_1_checked = $page_type_2_checked = $page_type_3_checked = $page_type_4_checked = "";
                                if($pageContent->page_type == 1) $page_type_1_checked = "checked";
                                if($pageContent->page_type == 2) $page_type_2_checked = "checked";
                                if($pageContent->page_type == 3) $page_type_3_checked = "checked";
                                if($pageContent->page_type == 4) $page_type_4_checked = "checked";
                                ?>

                                <input name="page_type" type="radio" id="page" value="3" class="with-gap <?php echo $this->lang->line("radio-col-x"); ?>" <?php echo $page_type_3_checked; ?>/>
                                <label for="page"><?php echo $this->lang->line("Page"); ?></label>
                                <input name="page_type" type="radio" id="version" value="4" class="with-gap <?php echo $this->lang->line("radio-col-x"); ?>" <?php echo $page_type_4_checked; ?>/>
                                <label for="version"><?php echo $this->lang->line("Version"); ?></label>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="form-line">
                                <?php
                                $page_status_checked = "";
                                if($pageContent->page_status == 1) $page_status_checked = "checked";
                                ?>
                                <input type="checkbox" class="filled-in <?php echo $this->lang->line("chk-col-x"); ?>" id="page_status" name="page_status" <?php echo $page_status_checked; ?>>
                                <label for="page_status"><?php echo $this->lang->line("Enable this page."); ?></label>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="">
                                <input type="hidden" readonly="readonly" name="page_id" value="<?php echo $pageContent->page_id; ?>" required>
                                <button <?php if($_SESSION['user_role_id'] == 4) echo "disabled='disabled'"; ?> type="submit" class="btn <?php echo $this->lang->line("bg-x"); ?> m-t-15 waves-effect"><?php echo $this->lang->line("Edit"); ?></button>
                            </div>
                        </div>

                        </form>

                    </div>
                </div>
            </div>
        </div>
        <!-- #END# Basic Examples -->
    </div>
</section>
<!-- TinyMCE -->
<script src="<?php echo base_url()."assets/dashboard/plugins/tinymce/tinymce.js"; ?>"></script>
<?php
$this->load->view('dashboard/common/footer_view');
?>
<script>
    tinymce.init({
        selector: '#page_content',
        height: 450,
        theme: 'modern',
        directionality: "<?php echo $this->lang->line('app_direction'); ?>",
        plugins: [
            "advlist autolink lists link image charmap print preview anchor",
            "searchreplace visualblocks code fullscreen",
            "insertdatetime media table contextmenu paste wordcount"
        ],
        toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image",
        setup : function(ed)
        {
            ed.on('init', function()
            {
                this.getDoc().body.style.fontSize = '13px';
                this.getDoc().body.style.fontFamily = 'Tahoma';
            });
        },

    });
</script>
